/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.custinfo;

import com.ibm.hwmca.base.custinfo.CustomerInfoConstants;
import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoTasklet;
import com.ibm.hwmca.base.custinfo.SystemBean;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;

public class SystemTasklet
extends PanelTasklet
implements CustomerInfoConstants {
    private static final String TRACE_MASKT = "XSETSYTT";
    private static final String TRACE_MASKF = "XSETSYTF";
    private static final String TRACE_MASKD = "XSETSYTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "SysInfoTskl");
    private SystemBean systemBean;

    public SystemTasklet() {
        Trace.trace(TRACE_MASKT, "<> SystemTasklet()");
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> init()");
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service(" + request + ", " + response + ")");
        try {
            if (request.isInitialRequest()) {
                this.systemBean = new SystemBean();
                this.systemBean.setBeanName("SystemBean");
                CustomerInfoTasklet custInfoTasklet = (CustomerInfoTasklet)this.getParent();
                CustomerInfoData custInfoData = custInfoTasklet.getCustInfoData();
                this.systemBean.setUseAdminMailingAddress(custInfoData.isSystemUseAdminAddr());
                this.systemBean.setStreetAddress(custInfoData.getSystemStreetAddr());
                this.systemBean.setStreetAddress2(custInfoData.getSystemStreetAddr2());
                this.systemBean.setCityLocality(custInfoData.getSystemCity());
                this.systemBean.setAvailCountries(custInfoTasklet.getAvailCountries());
                this.systemBean.setCountryCode(custInfoData.getSystemCountryCode());
                this.systemBean.setAvailSubdivisions(custInfoTasklet.getAvailSubdivisions());
                this.systemBean.setSubdivisionCode(custInfoData.getSystemSubdivisionCode());
                this.systemBean.setPostalCode(custInfoData.getSystemPostalCode());
                this.systemBean.setModemNumber(custInfoData.getSystemModemNumber());
                response.replace("com.ibm.hwmca.base.custinfo.res.CustomerInfoRes", "SystemPanel", this.systemBean);
            } else if (request.isDisposed() || request.isCanceled()) {
                response.terminate();
            } else {
                String source = (String)request.getData("Source");
                if (source == null) {
                    source = "";
                }
                Trace.trace(TRACE_MASKF, "source=" + source);
                if (source.equals("")) {
                    Trace.trace(TRACE_MASKF, "Unspecified source");
                    response.noAction();
                } else if (source.equals("SystemPanel")) {
                    this.serviceSystemPanel(request, response);
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown source");
                    response.noAction();
                }
            }
        }
        catch (TaskletException te) {
            throw te;
        }
        catch (Exception e) {
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKT, "<- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(classLogInfo, 2068, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }

    private void serviceSystemPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceSystemPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("Commit")) {
            SystemBean bean = (SystemBean)request.getData("Bean");
            if (bean != null) {
                CustomerInfoTasklet custInfoTasklet = (CustomerInfoTasklet)this.getParent();
                CustomerInfoData custInfoData = custInfoTasklet.getCustInfoData();
                custInfoData.setSystemUseAdminAddr(bean.isUseAdminMailingAddress());
                if (custInfoData.isSystemUseAdminAddr()) {
                    custInfoData.setSystemStreetAddr(custInfoData.getAdminStreetAddr());
                    custInfoData.setSystemStreetAddr2(custInfoData.getAdminStreetAddr2());
                    custInfoData.setSystemCity(custInfoData.getAdminCity());
                    custInfoData.setSystemCountryCode(custInfoData.getAdminCountryCode());
                    custInfoData.setSystemSubdivisionCode(custInfoData.getAdminSubdivisionCode());
                    custInfoData.setSystemPostalCode(custInfoData.getAdminPostalCode());
                } else {
                    custInfoData.setSystemStreetAddr(bean.getStreetAddress());
                    custInfoData.setSystemStreetAddr2(bean.getStreetAddress2());
                    custInfoData.setSystemCity(bean.getCityLocality());
                    custInfoData.setSystemCountryCode(bean.getCountryCode());
                    custInfoData.setSystemSubdivisionCode(bean.getSubdivisionCode());
                    custInfoData.setSystemPostalCode(bean.getPostalCode());
                }
                custInfoData.setSystemModemNumber(bean.getModemNumber());
                Trace.trace(TRACE_MASKF, custInfoData.toString());
            }
            response.noAction();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceSystemPanel()");
    }
}

